/* kSOAP
 *
 * The contents of this file are subject to the Enhydra Public License
 * Version 1.1 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License
 * on the Enhydra web site ( http://www.enhydra.org/ ).
 *
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See
 * the License for the specific terms governing rights and limitations
 * under the License.
 *
 * The Initial Developer of kSOAP is Stefan Haustein. Copyright (C)
 * 2000, 2001 Stefan Haustein, D-46045 Oberhausen (Rhld.),
 * Germany. All Rights Reserved.
 *
 * Contributor(s): John D. Beatty, Dave Dash, F. Hunter, Renaud Tognelli,
 *                 Thomas Strang, Alexander Krebs
 * */
 

package org.ksoap.transport;

import java.io.*;
import javax.microedition.io.*;

import org.kxml.*;
import org.kxml.io.*;
import org.kxml.parser.*;

import org.ksoap.*;

/** Methods to facilitate SOAP calls over HTTP using the 
    J2ME generic connection framework */

public class HttpTransport {

    String url;
    String soapAction = "\"\"";

    SoapEnvelope requestEnvelope = new SoapEnvelope ();
    SoapEnvelope responseEnvelope = new SoapEnvelope ();

    /** Set to true if debugging */
    public boolean debug;

    /** String dump of request for debugging. */   
    public String requestDump;

    /** String dump of response for debugging */
    public String responseDump;
 
    /** default constructor */
    public HttpTransport () {
    }


    /** 
     * Creates instance of HttpTransport with set url and SoapAction 
     *
     * @param url the destination to POST SOAP data
     * @param soapAction the desired SOAP action (for HTTP headers)
     */
    public HttpTransport (String url, String soapAction) {
	this.url = url;
	this.soapAction = soapAction;
    }


    /**
     * Set the target url.
     *
     * @param url the target url.
     */

    public void setUrl (String url) {
	this.url = url;
    }

    
    /**
     * set the desired soapAction header field
     *
     * @param soapAction the desired soapAction
     */

    public void setSoapAction (String soapAction) {
	this.soapAction = soapAction;
    }
    
    /**
     * setthe desired ClassMap for the SOAP Envelopes
     *
     * @param classMap the desired ClassMap
     */

    public void setClassMap (ClassMap classMap) {
	requestEnvelope.setClassMap (classMap);
	responseEnvelope.setClassMap (classMap);
    }


    /** Sends the requestEnvelope and fills the
	responseEnvelope
	@exception IOException if an error occurs
    */


    public void call () throws IOException {
	
	ByteArrayOutputStream bos = new ByteArrayOutputStream ();
	XmlWriter xw = new XmlWriter (new OutputStreamWriter (bos));
	requestEnvelope.write (xw); 
	xw.flush ();
	bos.write ('\r');
	bos.write ('\n');
	byte [] requestData = bos.toByteArray ();
	bos = null;
	xw = null;
	
	requestDump = debug ? new String (requestData) : null;
	responseDump = null;

	HttpConnection connection = (HttpConnection) Connector.open (url);
	
	connection.setRequestProperty ("SOAPAction", soapAction);
	connection.setRequestProperty ("Content-Type", "text/xml");
	connection.setRequestProperty 
	    ("Content-Length", ""+requestData.length);
	
	connection.setRequestProperty ("User-Agent", "kSOAP/0.98");

	connection.setRequestMethod (HttpConnection.POST);


	OutputStream os = connection.openOutputStream ();
	os.write (requestData, 0, requestData.length);
	//	os.flush ();  removed in order to avoid chunked encoding
	// opening the inputStream will perform an implicit close anyway

	requestData = null;

	InputStream is = connection.openInputStream ();

	if (debug) {
	    bos = new ByteArrayOutputStream ();
	    byte [] buf = new byte [256];
	    
	    while (true) {
		int rd = is.read (buf, 0, 256);
		if (rd == -1) break;
		bos.write (buf, 0, rd);
	    }

	    buf = bos.toByteArray ();
	    responseDump = new String (buf);
	    is.close ();
	    is = new ByteArrayInputStream (buf);
	}


	XmlParser xp = new XmlParser (new InputStreamReader (is));

	responseEnvelope.parse (xp);

	os.close ();
	is.close ();
	connection.close ();
    }

    
    /**
     * Executes a SOAP Method and returns a response
     *
     * @param method the remote soap method to be executed
     * @return the result of the soap method
     * @exception IOException if an error occurs
     */

    public Object call (SoapObject method) throws IOException {
	
	requestEnvelope.setBody (method);
	call ();
	
	if (responseEnvelope.getBody () instanceof SoapFault) 
	    throw((SoapFault)responseEnvelope.getBody ());

	return responseEnvelope.getResult ();
    }


}
